package gov.va.vinci.dart.json.builder;

import java.text.SimpleDateFormat;

import gov.va.vinci.dart.biz.NestableComment;
import gov.va.vinci.dart.json.CommentView;

public class CommentViewBuilder {
	public static final SimpleDateFormat SDF = new SimpleDateFormat("MM/dd/yyyy");

	// build a DTO from a business object
	public CommentView build(final NestableComment src) {
		CommentView view = new CommentView();
		view.setCommentId(src.getId());
		view.setParentId(src.getParentId());
		view.setActivityId(src.getActivityId());
		view.setRequestId(src.getRequestId());
		view.setAuthor(src.getCreatedBy());
		view.setCreated(SDF.format(src.getCreatedOn()));
		view.setDescription(src.getDescription());
		view.setCommentText(src.getText());
		
		int txtLen = src.getText().length();
		if (txtLen < 40) {
			view.setShortText(src.getText());
		}
		else {
			view.setShortText(src.getText().substring(0,40));
		}
		
		// comment status is always null
		
		return view;
	}
}
